/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.config;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.config.init.JsonConfigLessCollisions;
import com.charles445.rltweaker.config.json.JsonDoubleBlockState;
import com.charles445.rltweaker.config.json.JsonFileName;
import com.charles445.rltweaker.config.json.JsonTypeToken;
import com.charles445.rltweaker.entity.ai.InvestigateAIConfig;
import com.charles445.rltweaker.handler.ReskillableHandler;
import com.charles445.rltweaker.util.CollisionUtil;
import com.charles445.rltweaker.util.ErrorUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;

public class JsonConfig {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new TypeAdapter<ResourceLocation>(){

        public void write(JsonWriter out, ResourceLocation value) throws IOException {
            TypeAdapters.STRING.write(out, (Object)value.toString());
        }

        public ResourceLocation read(JsonReader in) throws IOException {
            return new ResourceLocation((String)TypeAdapters.STRING.read(in));
        }
    }).setPrettyPrinting().create();
    public static Map<String, Double> lessCollisions = new HashMap<String, Double>();
    public static Map<String, List<JsonDoubleBlockState>> reskillableTransmutation = new HashMap<String, List<JsonDoubleBlockState>>();
    public static Map<ResourceLocation, InvestigateAIConfig> investigateAI = new HashMap<ResourceLocation, InvestigateAIConfig>();

    public static void init() {
        if (ModConfig.patches.lessCollisions) {
            lessCollisions.putAll(JsonConfigLessCollisions.getDefaults());
            Map<String, Double> lcJson = JsonConfig.processJson(JsonFileName.lessCollisions, lessCollisions, true);
            if (lcJson != null) {
                try {
                    lessCollisions.putAll(lcJson);
                    JsonConfig.manuallyWriteToJson(JsonFileName.lessCollisions, lessCollisions);
                }
                catch (Exception e) {
                    RLTweaker.logger.error("Failed to merge write lessCollisions!");
                    ErrorUtil.logSilent("JSON Merge Write LessCollisions");
                }
            }
            if (lessCollisions == null) {
                lessCollisions = new HashMap<String, Double>();
            }
            CollisionUtil.instance.addToStringReference(lessCollisions);
        }
        if (Loader.isModLoaded((String)"reskillable") && ModConfig.server.reskillable.enabled && ModConfig.server.reskillable.customTransmutation) {
            Object reskillableHandler;
            reskillableTransmutation.clear();
            reskillableTransmutation.put("minecraft:stick", Arrays.asList(JsonDoubleBlockState.AIR));
            reskillableTransmutation = JsonConfig.processJson(JsonFileName.reskillableTransmutation, reskillableTransmutation, false);
            if (reskillableTransmutation != null && (reskillableHandler = RLTweaker.handlers.get("reskillable")) instanceof ReskillableHandler) {
                ((ReskillableHandler)reskillableHandler).registerTransmutations();
            }
        }
        try {
            JsonConfig.loadInvestigateAIConfig();
        }
        catch (JsonFileException e) {
            RLTweaker.logger.error("Failed to load investigate AI file '{}'", (Object)e.getFile(), (Object)e);
        }
        catch (IOException e) {
            RLTweaker.logger.error("Failed to load investigate AI config files", (Throwable)e);
        }
    }

    public static void loadInvestigateAIConfig() throws JsonFileException, IOException {
        investigateAI = JsonConfig.readJsons(RLTweaker.jsonDirectory.resolve("investigateAI"), InvestigateAIConfig.class);
    }

    @Nullable
    public static <T> T processJson(JsonFileName jfn, T container, boolean forMerging) {
        try {
            return JsonConfig.processUncaughtJson(jfn, container, forMerging);
        }
        catch (Exception e) {
            RLTweaker.logger.error("Error managing JSON File: " + jfn.get(), (Throwable)e);
            ErrorUtil.logSilent("JSON Error: " + jfn.get());
            if (forMerging) {
                return null;
            }
            return container;
        }
    }

    @Nullable
    public static <T> T processUncaughtJson(JsonFileName jfn, T container, boolean forMerging) throws Exception {
        String jsonFileName = jfn.get();
        Type type = JsonTypeToken.get(jfn);
        Path jsonFile = RLTweaker.jsonDirectory.resolve(jsonFileName);
        if (Files.exists(jsonFile, new LinkOption[0])) {
            return JsonConfig.readJsonFromFile(jsonFile, type);
        }
        JsonConfig.writeJsonToFile(jsonFile, type, container);
        if (forMerging) {
            return null;
        }
        return container;
    }

    private static <T> void manuallyWriteToJson(JsonFileName jfn, T container) throws Exception {
        String jsonFileName = jfn.get();
        Type type = JsonTypeToken.get(jfn);
        Path jsonFile = RLTweaker.jsonDirectory.resolve(jsonFileName);
        JsonConfig.writeJsonToFile(jsonFile, type, container);
    }

    private static <T> T readJsonFromFile(Path path, Type type) throws JsonIOException, JsonSyntaxException, IOException {
        try (BufferedReader in = Files.newBufferedReader(path);){
            Object object = GSON.fromJson((Reader)in, type);
            return (T)object;
        }
    }

    private static <T> T readJsonFromFile(Path path, Class<T> type) throws JsonIOException, JsonSyntaxException, IOException {
        try (BufferedReader in = Files.newBufferedReader(path);){
            Object object = GSON.fromJson((Reader)in, type);
            return (T)object;
        }
    }

    private static void writeJsonToFile(Path path, Type type, Object src) throws JsonIOException, IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (BufferedWriter out = Files.newBufferedWriter(path, new OpenOption[0]);){
            GSON.toJson(src, type, (Appendable)out);
        }
    }

    private static <V> Map<ResourceLocation, V> readJsons(Path dir, Class<V> type) throws JsonFileException, IOException {
        HashMap<ResourceLocation, V> map = new HashMap<ResourceLocation, V>();
        if (!Files.exists(dir, new LinkOption[0])) {
            return map;
        }
        for (Path subDir : (Path[])Files.list(dir).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).toArray(Path[]::new)) {
            String modid = subDir.getFileName().toString();
            for (Path file : (Path[])Files.list(subDir).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".json")).toArray(Path[]::new)) {
                V value;
                String fileName = file.getFileName().toString();
                ResourceLocation key = new ResourceLocation(modid, fileName.substring(0, fileName.lastIndexOf(46)));
                try {
                    value = JsonConfig.readJsonFromFile(file, type);
                }
                catch (JsonIOException | JsonSyntaxException e) {
                    throw new JsonFileException(dir.relativize(file), e);
                }
                map.put(key, value);
            }
        }
        return map;
    }

    public static class JsonFileException
    extends Exception {
        private final Path file;

        public JsonFileException(Path file, Throwable cause) {
            super(cause);
            this.file = file;
        }

        public Path getFile() {
            return this.file;
        }
    }
}

